/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.builder.network;

import java.util.function.Supplier;
import mcjty.rftoolsbuilder.modules.builder.blocks.BuilderTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateNBTItemInventoryShape {
    private BlockPos pos;
    private int slotIndex;
    private CompoundTag tagCompound;

    public PacketUpdateNBTItemInventoryShape() {
    }

    public PacketUpdateNBTItemInventoryShape(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.slotIndex = buf.readInt();
        this.tagCompound = buf.m_130260_();
    }

    public PacketUpdateNBTItemInventoryShape(BlockPos pos, int slotIndex, CompoundTag tagCompound) {
        this.pos = pos;
        this.slotIndex = slotIndex;
        this.tagCompound = tagCompound;
    }

    protected boolean isValidBlock(Level world, BlockPos blockPos, BlockEntity tileEntity) {
        return tileEntity instanceof BuilderTileEntity;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.slotIndex);
        buf.m_130079_(this.tagCompound);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Level world = ctx.getSender().m_20193_();
            BlockEntity te = world.m_7702_(this.pos);
            if (te != null) {
                if (!this.isValidBlock(world, this.pos, te)) {
                    return;
                }
                te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> {
                    ItemStack stack = h.getStackInSlot(this.slotIndex);
                    if (!stack.m_41619_()) {
                        stack.m_41751_(this.tagCompound);
                    }
                });
            }
        });
        ctx.setPacketHandled(true);
    }
}

